#!/usr/bin/env python
import pyfirmata
from Tkinter import *

arduinoboard = pyfirmata.Arduino('/dev/ttyACM0')

pin3 = arduinoboard.get_pin('d:3:p') # Pin 3 als PWM

def cleanup():
    # LED 3 ausschalten
    pin3.write(0)
    arduinoboard.exit()
    
def setPWM(pwm):
    # LED 3 mit PWM ansteuern
    # Es werden Werte zwischen 0 und 1 akzeptiert
    pin3.write(float(pwm)/100.0)    

# GUI
master = Tk()
master.wm_protocol("WM_DELETE_WINDOW", cleanup)

# Schieberegler initialisieren
scale = Scale(master,
    from_ = 0,
    to = 100,
    command = setPWM,
    orient = HORIZONTAL,
    length = 400,
    label = 'PWM-Value')

scale.pack(anchor = CENTER) # Mittig platzieren
master.mainloop()           # TK Event-Loop starten
